local t = Def.ActorFrame {};

local function UpdateTime(self)
	local c = self:GetChildren();
	for pn in ivalues(PlayerNumber) do
		local vStats = STATSMAN:GetCurStageStats():GetPlayerStageStats( pn );
		local vTime;
		local obj = self:GetChild( string.format("RemainingTime" .. PlayerNumberToString(pn) ) );
		if vStats and obj then
			vTime = vStats:GetLifeRemainingSeconds()
			obj:settext( SecondsToMMSSMsMs( vTime ) );
		end;
	end;
end

if GAMESTATE:GetCurrentCourse() then
	if GAMESTATE:GetCurrentCourse():GetCourseType() == "CourseType_Survival" then
		-- RemainingTime
		for pn in ivalues(PlayerNumber) do
			local MetricsName = "RemainingTime" .. PlayerNumberToString(pn);
			t[#t+1] = LoadActor( THEME:GetPathG( Var "LoadingScreen", "RemainingTime"), pn ) .. {
				InitCommand=function(self) 
					self:player(pn); 
					self:name(MetricsName); 
					self:zoom(4);
					ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen"); 
				end;
			};
		end
		
		for pn in ivalues(PlayerNumber) do
			local MetricsName = "DeltaSeconds" .. PlayerNumberToString(pn);
			t[#t+1] = LoadActor( THEME:GetPathG( Var "LoadingScreen", "DeltaSeconds"), pn ) .. {
				InitCommand=function(self) 
					self:player(pn); 
					self:name(MetricsName); 
					ActorUtil.LoadAllCommandsAndSetXY(self,Var "LoadingScreen"); 
				end;
			};
		end
	end;
end;

t.InitCommand=cmd(SetUpdateFunction,UpdateTime);
t[#t+1] = LoadActor("Normal")..{InitCommand=cmd(draworder,105)};

local Players = GAMESTATE:GetEnabledPlayers()
for player in ivalues(Players) do
	local pn = ToEnumShortString(player)



	-- Check if MeasureCounter is turned on;
	-- we may (or may not) need to parse the chart.
	local mods = MetroQuad[pn].ActiveModifiers
	if mods.MeasureCounter and mods.MeasureCounter ~= "None" then

		local song_dir = GAMESTATE:GetCurrentSong():GetSongDir()
		local steps = GAMESTATE:GetCurrentSteps(player)
		local steps_type = ToEnumShortString( steps:GetStepsType() ):gsub("_", "-"):lower()
		local difficulty = ToEnumShortString( steps:GetDifficulty() )
		local notes_per_measure = tonumber(mods.MeasureCounter:match("%d+"))
		local threshold_to_be_stream = 2

		-- if any of these don't match what we're currently looking for...
		if MetroQuad[pn].Streams.SongDir ~= song_dir or MetroQuad[pn].Streams.StepsType ~= step_type or MetroQuad[pn].Streams.Difficulty ~= difficulty then

			-- ...then parse the simfile, given the current parameters
			MetroQuad[pn].Streams.Measures = GetStreams(song_dir, steps_type, difficulty, notes_per_measure, threshold_to_be_stream)
			-- and set these so we can check again next time.
			MetroQuad[pn].Streams.SongDir = song_dir
			MetroQuad[pn].Streams.StepsType = steps_type
			MetroQuad[pn].Streams.Difficulty = difficulty
		end
	end
end

for pn in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = LoadActor("SubtractiveScoring",pn)
	t[#t+1] = LoadActor("MeasureCounter",pn)
end

if not GAMESTATE:IsCourseMode() then
	if IsAutoRestartEnabled() then t[#t+1] = LoadActor("AutoRestart") end
	t[#t+1] = LoadActor("PercentScore")
	t[#t+1] = LoadActor("StepsDisplayFrame")..{InitCommand=cmd(draworder,107)};
	t[#t+1] = LoadActor("NotesPerSecondP1")..{InitCommand=cmd(visible,IsNPSEnabled(PLAYER_1) and IsPlayerEnabled(PLAYER_1) and not IsDemonstration())};
	t[#t+1] = LoadActor("NotesPerSecondP2")..{InitCommand=cmd(visible,IsNPSEnabled(PLAYER_2) and IsPlayerEnabled(PLAYER_2) and not IsDemonstration())};

	if GetCurrentStyle():GetName() == "single" then
		t[#t+1] = LoadActor("Tabs/TabP1Numbers")
		t[#t+1] = LoadActor("Tabs/TabP2Numbers")
		if IsPlayerEnabled(PLAYER_1) then
			t[#t+1] = LoadActor("Tabs/InformationP1")
			t[#t+1] = LoadActor("Tabs/GraphDisplayP1") -- Tab 1 (Dont load this file without a Player 1.
			t[#t+1] = LoadActor("Tabs/JudgmentsP1") -- Tab 1
			t[#t+1] = LoadActor("Tabs/TopRecordsP1") -- Tab 2
			t[#t+1] = LoadActor("Tabs/PerColumnJudgmentsP1") -- Tab 3
			t[#t+1] = LoadActor("Tabs/SongInformationP1") -- Tab 4
		end
		if IsPlayerEnabled(PLAYER_2) then
			t[#t+1] = LoadActor("Tabs/InformationP2")
			t[#t+1] = LoadActor("Tabs/GraphDisplayP2") -- Tab 1 (Dont load this file without a Player 2.
			t[#t+1] = LoadActor("Tabs/JudgmentsP2") -- Tab 1
			t[#t+1] = LoadActor("Tabs/TopRecordsP2") -- Tab 2
			t[#t+1] = LoadActor("Tabs/PerColumnJudgmentsP2") -- Tab 3
			t[#t+1] = LoadActor("Tabs/SongInformationP2") -- Tab 4
		end
	end
end

t[#t+1] = LoadActor("SongMeter")..{InitCommand=cmd(draworder,999)};

t[#t+1] = Def.ActorFrame{
	Def.Quad {
		InitCommand=cmd(xy,CenterX(),Bottom();valign,1;setsize,Width(),16;diffuse,Black());
	};
	Def.Quad {
		InitCommand=cmd(draworder,-1;x,CenterX();y,Bottom();valign,1;zoomto,Width(),40;diffuse,color(LoadFile("ThemeColor.cfg","Settings")));
	};
};

return t